/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.discovery;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.fabricmc.loader.impl.FormattedException;
import net.fabricmc.loader.impl.discovery.ModCandidate;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.lib.accesswidener.AccessWidenerReader;
import net.fabricmc.loader.impl.lib.accesswidener.AccessWidenerRemapper;
import net.fabricmc.loader.impl.lib.accesswidener.AccessWidenerWriter;
import net.fabricmc.loader.impl.lib.tinyremapper.InputTag;
import net.fabricmc.loader.impl.lib.tinyremapper.NonClassCopyMode;
import net.fabricmc.loader.impl.lib.tinyremapper.OutputConsumerPath;
import net.fabricmc.loader.impl.lib.tinyremapper.TinyRemapper;
import net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.MixinExtension;
import net.fabricmc.loader.impl.util.FileSystemUtil;
import net.fabricmc.loader.impl.util.ManifestUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.mappings.TinyRemapperMappingsHelper;
import org.objectweb.asm.commons.Remapper;

public final class RuntimeModRemapper {
    private static final String REMAP_TYPE_MANIFEST_KEY = "Fabric-Loom-Mixin-Remap-Type";
    private static final String REMAP_TYPE_STATIC = "static";

    public static void remap(Collection<ModCandidate> modCandidates, Path tmpDir, Path outputDir) {
        ArrayList<ModCandidate> modsToRemap = new ArrayList<ModCandidate>();
        HashSet<InputTag> remapMixins = new HashSet<InputTag>();
        for (ModCandidate mod : modCandidates) {
            if (!mod.getRequiresRemap()) continue;
            modsToRemap.add(mod);
        }
        if (modsToRemap.isEmpty()) {
            return;
        }
        FabricLauncher launcher = FabricLauncherBase.getLauncher();
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(TinyRemapperMappingsHelper.create(launcher.getMappingConfiguration().getMappings(), "intermediary", launcher.getTargetNamespace())).renameInvalidLocals(false).extension(new MixinExtension(remapMixins::contains)).build();
        try {
            remapper.readClassPathAsync(RuntimeModRemapper.getRemapClasspath().toArray(new Path[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to populate remap classpath", e);
        }
        HashMap<ModCandidate, RemapInfo> infoMap = new HashMap<ModCandidate, RemapInfo>();
        try {
            RemapInfo info;
            for (ModCandidate mod : modsToRemap) {
                InputTag tag;
                info = new RemapInfo();
                infoMap.put(mod, info);
                info.tag = tag = remapper.createInputTag();
                if (mod.hasPath()) {
                    List<Path> paths = mod.getPaths();
                    if (paths.size() != 1) {
                        throw new UnsupportedOperationException("multiple path for " + mod);
                    }
                    info.inputPath = paths.get(0);
                } else {
                    info.inputPath = mod.copyToDir(tmpDir, true);
                    info.inputIsTemp = true;
                }
                if (RuntimeModRemapper.requiresMixinRemap(info.inputPath)) {
                    remapMixins.add(tag);
                }
                info.outputPath = outputDir.resolve(mod.getDefaultFileName());
                Files.deleteIfExists(info.outputPath);
                remapper.readInputsAsync(tag, info.inputPath);
            }
            for (ModCandidate mod : modsToRemap) {
                info = (RemapInfo)infoMap.get(mod);
                OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(info.outputPath).build();
                FileSystemUtil.FileSystemDelegate delegate = FileSystemUtil.getJarFileSystem(info.inputPath, false);
                if (delegate.get() == null) {
                    throw new RuntimeException("Could not open JAR file " + info.inputPath.getFileName() + " for NIO reading!");
                }
                Path inputJar = delegate.get().getRootDirectories().iterator().next();
                outputConsumer.addNonClassFiles(inputJar, NonClassCopyMode.FIX_META_INF, remapper);
                info.outputConsumerPath = outputConsumer;
                remapper.apply(outputConsumer, info.tag);
            }
            for (ModCandidate mod : modsToRemap) {
                info = (RemapInfo)infoMap.get(mod);
                String accessWidener = mod.getMetadata().getAccessWidener();
                if (accessWidener == null) continue;
                info.accessWidenerPath = accessWidener;
                try {
                    FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(info.inputPath, false);
                    try {
                        FileSystem fs = jarFs.get();
                        info.accessWidener = RuntimeModRemapper.remapAccessWidener(Files.readAllBytes(fs.getPath(accessWidener, new String[0])), remapper.getRemapper());
                    }
                    finally {
                        if (jarFs == null) continue;
                        jarFs.close();
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error remapping access widener for mod '" + mod.getId() + "'!", t);
                }
            }
            remapper.finish();
            for (ModCandidate mod : modsToRemap) {
                info = (RemapInfo)infoMap.get(mod);
                info.outputConsumerPath.close();
                if (info.accessWidenerPath != null) {
                    try (FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(info.outputPath, false);){
                        FileSystem fs = jarFs.get();
                        Files.delete(fs.getPath(info.accessWidenerPath, new String[0]));
                        Files.write(fs.getPath(info.accessWidenerPath, new String[0]), info.accessWidener, new OpenOption[0]);
                    }
                }
                mod.setPaths(Collections.singletonList(info.outputPath));
            }
        }
        catch (Throwable t) {
            try {
                remapper.finish();
                for (RemapInfo info : infoMap.values()) {
                    if (info.outputPath == null) continue;
                    try {
                        Files.deleteIfExists(info.outputPath);
                    }
                    catch (IOException e) {
                        Log.warn(LogCategory.MOD_REMAP, "Error deleting failed output jar %s", info.outputPath, e);
                    }
                }
                throw new FormattedException("Failed to remap mods!", t);
            }
            catch (Throwable throwable) {
                for (RemapInfo info : infoMap.values()) {
                    try {
                        if (!info.inputIsTemp) continue;
                        Files.deleteIfExists(info.inputPath);
                    }
                    catch (IOException e) {
                        Log.warn(LogCategory.MOD_REMAP, "Error deleting temporary input jar %s", info.inputIsTemp, e);
                    }
                }
                throw throwable;
            }
        }
        for (RemapInfo info : infoMap.values()) {
            try {
                if (!info.inputIsTemp) continue;
                Files.deleteIfExists(info.inputPath);
            }
            catch (IOException e) {
                Log.warn(LogCategory.MOD_REMAP, "Error deleting temporary input jar %s", info.inputIsTemp, e);
            }
        }
    }

    private static byte[] remapAccessWidener(byte[] input, Remapper remapper) {
        AccessWidenerWriter writer = new AccessWidenerWriter();
        AccessWidenerRemapper remappingDecorator = new AccessWidenerRemapper(writer, remapper, "intermediary", "named");
        AccessWidenerReader accessWidenerReader = new AccessWidenerReader(remappingDecorator);
        accessWidenerReader.read(input, "intermediary");
        return writer.write();
    }

    private static List<Path> getRemapClasspath() throws IOException {
        String remapClasspathFile = System.getProperty("fabric.remapClasspathFile");
        if (remapClasspathFile == null) {
            throw new RuntimeException("No remapClasspathFile provided");
        }
        String content = new String(Files.readAllBytes(Paths.get(remapClasspathFile, new String[0])), StandardCharsets.UTF_8);
        return Arrays.stream(content.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    private static boolean requiresMixinRemap(Path inputPath) throws IOException, URISyntaxException {
        Manifest manifest = ManifestUtil.readManifest(inputPath.toUri().toURL());
        Attributes mainAttributes = manifest.getMainAttributes();
        return REMAP_TYPE_STATIC.equalsIgnoreCase(mainAttributes.getValue(REMAP_TYPE_MANIFEST_KEY));
    }

    private static class RemapInfo {
        InputTag tag;
        Path inputPath;
        Path outputPath;
        boolean inputIsTemp;
        OutputConsumerPath outputConsumerPath;
        String accessWidenerPath;
        byte[] accessWidener;

        private RemapInfo() {
        }
    }
}

